var nav_parseScript = function (script, pos, options, printNode, printResult) {
    try {
        var scriptPos = pos;
        if (scriptPos < 0 || scriptPos > script.length)
            scriptPos = script.length;

        // obtain actual node
        var fullNode = null;
        var actualNode = null;
        var assignments = null;
        var findActualNode = false;

        if (options && options.findActualNode === true)
            findActualNode = options.findActualNode;
        if (options && options.findAssignments === true)
            assignments = [];  

        if (findActualNode) {
            fullNode = acorn.parse_dammit(script, {});
            var findNodeAroundFunc = function (nodeType, node) {
                actualNode = Object.extend({}, node);
                return true;
            }
            acorn.walk.findNodeAround(fullNode, scriptPos, findNodeAroundFunc);
        }
        else {
            fullNode = acorn.parse(script, {});
        }

        if (Object.keys(fullNode).length > 0) {
            if (printNode) {
                printResult.fullNode = fullNode
                if (actualNode) {
                    printResult.node = actualNode;
                    printResult.nodeScript = script.substring(actualNode.start, actualNode.g_end);
                }
            }

            /*
            parseNode result:
                first array is complete statements
                e.g. db.test.find(); db.test.find() << there are 2 statements and hence first array contains 2 items
                in each array, contains another array for the step in each statement
                e.g. db.test.find() -> db, test, find
            */
            var parseNode = function (node, parentNode) {
                var parseResult = [];
                if (node == null)
                    parseResult;

                // this part should be the outermost node, review if have more
                if (node.type == 'Program') {
                    // convert to an array contains another array
                    // first level array is for each statement
                    // second level array is the structure in each statement
                    node.body.forEach(argument => {
                        var tmpResult = parseNode(argument, node);  
                        if (tmpResult)
                            parseResult.push(tmpResult); 
                    }); 
                }
                else if (node.type == 'ExpressionStatement') {
                    var tmpResult = parseNode(node.expression, node);  
                    if (tmpResult)
                        parseResult.push(...tmpResult); 
                }  
                else if (node.type == 'BlockStatement') {
                    // syntax: { ... }
                    // convert obj.body to an array contains another array, it is similar to Program
                    var obj = Object.extend({}, node);
                    obj.type2 = ['block'];   
                    var statements = [];
                    if (node.body)  {
                        node.body.forEach(argument => {
                            var tmpResult = parseNode(argument, node);  
                            if (tmpResult)
                                statements.push(tmpResult); 
                        });           
                    }
                    obj.body = statements;  
                    parseResult.push(obj); 
                } 
                else if (node.type == 'IfStatement') {
                    // syntax: if ... else ...
                    // there is no special handling so far
                    // review if require 
                    var obj = Object.extend({}, node);
                    obj.type2 = ['if'];
                    if (node.test) {
                        // array, there should be one statement only
                        var tmpResult = parseNode(node.test, node);  
                        obj.condition = tmpResult;
                        delete obj.test;
                    }
                    if (node.consequent) {
                        // if have  {}, directly extact content
                        // should be array of array
                        if (node.consequent.type == 'BlockStatement') {
                            var statements = [];
                            node.consequent.body.forEach(argument => {
                                var tmpResult = parseNode(argument, node);  
                                if (tmpResult)
                                    statements.push(tmpResult); 
                            });      
                            obj.ifTrue = statements;    
                        }
                        else {
                            var tmpResult = parseNode(node.consequent, node);  
                            obj.ifTrue = [tmpResult];
                        }
                        delete obj.consequent;
                    }
                    if (node.alternate) {
                        // if have  {}, directly extact content
                        // should be array of array
                        if (node.alternate.type == 'BlockStatement') {
                            var statements = [];
                            node.alternate.body.forEach(argument => {
                                var tmpResult = parseNode(argument, node);  
                                if (tmpResult)
                                    statements.push(tmpResult); 
                            });      
                            obj.ifFalse = [statements];    
                        }
                        else {
                            var tmpResult = parseNode(node.alternate, node);  
                            obj.ifFalse = tmpResult;
                        }
                        delete obj.alternate;
                    }
                    parseResult.push(obj); 
                }
                else if (node.type == 'WithStatement') {
                    // syntax: if ... else ...
                    // there is no special handling so far
                    // review if require 
                    var obj = Object.extend({}, node);
                    obj.type2 = ['with'];
                    if (node.object) {
                        // array, there should be one statement only
                        var tmpResult = parseNode(node.object, node);  
                        obj.object = tmpResult;
                    }
                    if (node.body) {
                        // if have  {}, directly extact content
                        // should be array of array
                        if (node.body.type == 'BlockStatement') {
                            var statements = [];
                            node.body.body.forEach(argument => {
                                var tmpResult = parseNode(argument, node);  
                                if (tmpResult)
                                    statements.push(tmpResult); 
                            });      
                            obj.body = statements;    
                        }
                        else {
                            var tmpResult = parseNode(node.body, node);  
                            obj.body = [tmpResult];
                        }
                    }  
                    parseResult.push(obj);                   
                }
                else if (node.type == 'SwitchStatement') {
                    // syntax: switch (... ) {case ... : ... }
                    // there is no special handling so far
                    // review if require 
                    var obj = Object.extend({}, node);
                    obj.type2 = ['switch'];
                    parseResult.push(obj);                   
                }
                else if (node.type == 'WhileStatement') {
                    // syntax: while (...) {...}
                    // there is no special handling so far
                    // review if require 
                    var obj = Object.extend({}, node);
                    obj.type2 = ['while'];
                    parseResult.push(obj);                   
                }   
                else if (node.type == 'DoWhileStatement') {
                    // syntax: while (...) {...}
                    // there is no special handling so far
                    // review if require 
                    var obj = Object.extend({}, node);
                    obj.type2 = ['doWhile'];
                    parseResult.push(obj);                   
                }   
                else if (node.type == 'ForStatement') {
                    // syntax: for (...) {...}
                    // there is no special handling so far
                    // review if require 
                    var obj = Object.extend({}, node);
                    obj.type2 = ['for'];
                    parseResult.push(obj);                   
                }   
                else if (node.type == 'ForInStatement') {
                    // syntax: for (... in ...) {...}
                    // there is no special handling so far
                    // review if require 
                    var obj = Object.extend({}, node);
                    obj.type2 = ['forIn'];
                    parseResult.push(obj);                   
                }         
                else if (node.type == 'ReturnStatement') {
                    // syntax: return ...
                    var tmpResult = parseNode(node.argument, node);  
                    if (tmpResult) {
                        for (var i in tmpResult)
                            tmpResult[i].type2.push("return");                      
                        parseResult.push(...tmpResult); 
                    }
                }
                else if (node.type == 'ContinueStatement') {
                    var obj = Object.extend({}, node);
                    obj.type2 = [];
                    parseResult.push(obj); 
                }     
                else if (node.type == 'BreakStatement') {
                    var obj = Object.extend({}, node);
                    obj.type2 = [];
                    parseResult.push(obj); 
                }     
                else if (node.type == 'LabeledStatement') {
                    var obj = Object.extend({}, node);
                    obj.type2 = [];
                    parseResult.push(obj); 
                }  
                else if (node.type == 'VariableDeclaration') {
                    // syntax: var/let/const ...
                    // there is no special handling so far
                    // review if require 
                    var obj = Object.extend({}, node);
                    obj.type2 = [];
                    parseResult.push(obj); 
                }
                else if (node.type == 'AssignmentExpression') {
                    // ... = ...
                    // there is no special handling so far
                    // review if require 
                    var obj = Object.extend({}, node);
                    obj.type2 = [];
                    parseResult.push(obj); 
                }  
                else if (node.type == 'ObjectExpression') {
                    // syntax: { ... }
                    // review if require 
                    var obj = Object.extend({}, node);
                    obj.type2 = [];
                    obj.properties = [];
                    node.properties.forEach(property => {
                        var tmpResult = parseNode(property.key, node);  
                        var tmpResult2 = parseNode(property.value, node);  
                        if (tmpResult) {
                            if (tmpResult.length > 0) {
                                tmpResult[tmpResult.length-1].type2.push("assignment");
                                tmpResult[tmpResult.length-1].assignment = tmpResult2;
                            }                            
                            obj.properties.push(...tmpResult); 
                        }
                    }); 
                    parseResult.push(obj);    
                } 
                else if (node.type == 'BinaryExpression') {
                    // ... + ... 
                    // ... * ... , etc
                    var tmpResult = parseNode(node.left, node);  
                    if (tmpResult) {
                        for (var i in tmpResult)
                            tmpResult[i].type2.push("operation");    
                        if (tmpResult.length > 0)
                            tmpResult[tmpResult.length-1].operator = node.operator;                 
                        parseResult.push(...tmpResult); 
                    }
                    tmpResult = parseNode(node.right, node);  
                    if (tmpResult) {
                        for (var i in tmpResult)
                            tmpResult[i].type2.push("operation");                   
                        parseResult.push(...tmpResult); 
                    }
                }                  
                else if (node.type == 'FunctionExpression' ||
                         node.type == 'FunctionDeclaration' ||
                         node.type == 'ArrowExpression') {
                    // FunctionExpression syntax: ... = function ... (...) {...}
                    // FunctionDeclaration syntax: function ... (...) {...}
                    // ArrowExpression syntax: (...) -> {...}, no id
                    // function body is an array contains 1 BlockStatement
                    // review if have another syntax
                    // there are id, generator, expression, params, review if require
                    var obj = Object.extend({}, node);
                    obj.type2 = ['function'];
                    if (node.body && node.body.type == 'BlockStatement') {
                        var statements = [];
                        node.body.body.forEach(argument => {
                            var tmpResult = parseNode(argument, node);  
                            if (tmpResult)
                                statements.push(tmpResult); 
                        });      
                        obj.body = statements;    
                    }
                    else
                        delete obj.body;
                    parseResult.push(obj); 
                }                     
                else if (node.type == 'CallExpression') {
                    var topCallee = null;
                    if (node.callee != null) {
                        var callee = node.callee;
                        var tmpResult = parseNode(callee, node); 
                        if (tmpResult.length > 0) {
                            tmpResult[tmpResult.length-1].type2.push("callee");
                            topCallee = tmpResult[tmpResult.length-1];
                        }
                        parseResult.push(...tmpResult); 
                    }
                    if (topCallee && node.arguments != null) {
                        var tmpResult = [];
                        var arguments = node.arguments;
                        for (var i in arguments)
                            tmpResult.push(...parseNode(arguments[i], node));
                        for (var i in tmpResult)
                            tmpResult[i].type2.push("arguments");
                        // add to topCallee as those args is for one function call only
                        topCallee.arguments = tmpResult;
                        // record actual function ) position into callee
                        topCallee.functionEnd = node.end;
                    }

                }
                else if (node.type == 'MemberExpression') {
                    var objectResult = null;
                    if (node.object != null) {
                        var object = node.object;
                        var tmpResult = parseNode(object, node);  
                        if (tmpResult.length > 0) {
                            objectResult = tmpResult[tmpResult.length-1];
                        }
                        parseResult.push(...tmpResult);             
                    }
                    if (node.property != null){
                        var property = node.property;
                        var tmpResult = parseNode(property, node);  
                        for (var i in tmpResult) {
                            tmpResult[i].type2.push("property");
                            // mark parent for tracing 
                            tmpResult[i].parent = objectResult;
                            // mark computed for checking property cases. e.g. can be . or []
                            tmpResult[i].computed = node.computed;
                        }
                        parseResult.push(...tmpResult);     
                    }
                }
                else if (node.type == 'ThisExpression') {
                    // there is no special handling so far
                    // review if require 
                    var obj = Object.extend({}, node);
                    obj.type2 = [];
                    parseResult.push(obj);                    
                }
                else if (node.type == 'ArrayExpression') {
                    // syntax: [ ... ]
                    // there is no special handling so far
                    // review if require 
                    var obj = Object.extend({}, node);
                    obj.type2 = [];
                    parseResult.push(obj);                    
                }          
                else if (node.type == 'SequenceExpression') {
                    // syntax: ,...,...
                    if (node.expressions) {
                        var tmpResult = parseNode(node.expressions, node);  
                        node.expressions.forEach(element => {
                            var tmpResult = parseNode(element, node);  
                            if (tmpResult)
                                parseResult.push(...tmpResult); 
                        });                           
                    }              
                }          
                else if (node.type == 'Identifier') {
                    // if name is X, it is an invalid object, skip
                    if (node.name != '✖') {
                        var obj = Object.extend({}, node);
                        obj.type2 = [];
                        parseResult.push(obj);  
                    }
                }
                else if (node.type == 'Literal') {
                    var obj = Object.extend({}, node);
                    obj.type2 = [];
                    parseResult.push(obj); 
                }
                // there are many types that havent supported, support to require
                return parseResult;    
            }

            rephrasedResult = {}
            if (findActualNode)
                rephrasedResult.actualNode = [parseNode(actualNode)];           
            rephrasedResult.fullNode = parseNode(fullNode);

            if (assignments) {
                acorn.walk.simple(fullNode, {
                    VariableDeclaration(node) {
                        if (node.declarations) {
                            node.declarations.forEach(element => {
                                var tmpResult = parseNode(element.id, node);  
                                var tmpResult2 = parseNode(element.init, node);  
                                if (tmpResult) {
                                    if (tmpResult.length > 0) {
                                        tmpResult[tmpResult.length-1].type2.push("assignment");
                                        tmpResult[tmpResult.length-1].assignment = tmpResult2;
                                    }                            
                                    assignments.push(tmpResult); 
                                }
                            });    
                        }
                    },
                    AssignmentExpression(node) {                        
                        // ... = ...
                        // left side can be a, or a.b, etc
                        if (node.operator && node.operator == '=') {
                            var tmpResult = parseNode(node.left, node);  
                            var tmpResult2 = parseNode(node.right, node);  
                            if (tmpResult) {
                                if (tmpResult.length > 0) {
                                    tmpResult[tmpResult.length-1].type2.push("assignment");
                                    tmpResult[tmpResult.length-1].assignment = tmpResult2;
                                }                            
                                assignments.push(tmpResult); 
                            }
                        }
                    }
                  });

                var reparseAssignments = function (_assignments) {
                    if (!_assignments)
                        return [];

                    var newAssignments = [];
                    _assignments.forEach(assignment => {
                        var newAssignment = [];
                        assignment.forEach(node => {
                            newAssignment.push(node);
                            if (node.assignment && 
                                node.assignment.length > 0 &&
                                node.assignment[0].type == 'ObjectExpression') {
                                    node.assignment[0].properties.forEach(property => {
                                        newAssignment2 = newAssignment.slice(0);
                                        newAssignment2.push(property);
                                        newAssignments.push(newAssignment2);
                                    });
                            }
                        });			
                        newAssignments.push(newAssignment);
                    });	
                    
                    return newAssignments;
                }
                rephrasedResult.assignments = reparseAssignments(assignments);    
            }

            return rephrasedResult;
        }    
    } catch(e) {
        throw e;
    } 
    return {}; 
}

var arrayContains = function(sourceArray, target) {
    if (Array.isArray(sourceArray))
        return (sourceArray.indexOf(target) > -1);
    else if (sourceArray == target)
        return true;
    return false;
}

var arrayLastElementEquals = function(sourceArray, target) {
    if (Array.isArray(sourceArray) && sourceArray.length > 0)
        return sourceArray[sourceArray.length - 1] == target;
    else if (sourceArray == target)
        return true;        
    return false;
}

var isDB = function (node) {
    if (!node)
        return false;

    // db.
    if (node.type == 'Identifier' && node.name == 'db' && node.type2.length == 0)
        return true;       

    // this.db.
    if (isProperty(node) == 'db' && isGlobal(node.parent))
        return true;

    // db.getSiblingDB()
    if (isFunctionNode(node, ['getSiblingDB','getSisterDB']) && isDB(node.parent))
        return true;  

    if (isFunctionNode(node, ['getDatabase']) && isSession(node.parent))
        return true;  

    if (isFunctionNode(node, ['getDB']) && isMongo(node.parent))
        return true;  

    return false; 
}

var isCollection = function (node, allowSquareBracketsWithIdentifier = false) {
    if (!node)
        return false;

    if (isFunctionNode(node, 'getCollection') || isProperty(node, allowSquareBracketsWithIdentifier) !== false) {
        if (isDB(node.parent))
            return true;
        return isCollection(node.parent, allowSquareBracketsWithIdentifier);
    }

    return false; 
}

var isCursor = function (node) {
    if (!node)
        return false;

    return false;                   
} 

// copy list from db.collection.find().help()
// exclude count as cant have function after it
var possibleCollectionFindFunctions = ['sort', 'limit', 'skip', 'batchSize', 'collation', 'hint', 'readConcern', 'readPref', 'size', 'explain', 'min', 'max', 'maxScan', 'maxTimeMS', 'comment', 'snapshot', 'tailable', 'noCursorTimeout', 'allowPartialResults', 'returnKey', 'showRecordId'];
possibleCollectionFindFunctions.push('allowDiskUse', 'maxAwaitTimeMS'); // mongosh
var isCollectionFind = function (node) {
    if (!node)
        return false;
        
    if (functionName = isFunctionNode(node)) {
        if (functionName == 'find')
            return isCollection(node.parent);
        else if (arrayContains(possibleCollectionFindFunctions, functionName))
            return isCollectionFind(node.parent);
    }

    return false;                   
}

//var possibleCollectionExplainFunctions = ['aggregate', 'count', 'distinct', 'find', 'findAndModify', 'group', 'remove', 'update'];
var isCollectionExplain = function (node) {
    if (!node)
        return false;
        
    if (functionName = isFunctionNode(node)) {
        if (functionName == 'explain') {
            return isCollection(node.parent);
        }
    }

    return false;                   
}

// copy list from db.collection.explain().find().help()
// exclude count as cant have function after it
var possibleCollectionExplainFindFunctions = ['addOption', 'batchSize', 'comment', 'collation', 'hint', 'limit', 'maxTimeMS', 'max', 'min', 'readPref', 'showDiskLoc', 'skip', 'snapshot', 'sort'];
possibleCollectionExplainFindFunctions.push('allowDiskUse', 'maxAwaitTimeMS'); // mongosh
var isCollectionExplainFind = function (node) {
    if (!node)
        return false;

    if (functionName = isFunctionNode(node)) {
        if (functionName == 'find') {
            if (isFunctionNode(node.parent, 'explain'))
                return isCollection(node.parent.parent);
            return false;
        }
        else if (arrayContains(possibleCollectionExplainFindFunctions, functionName)) {
            return isCollectionExplainFind(node.parent);
        }
    }

    return false;                   
}    

var isWriteResult = function (node) {
    if (!node)
        return false;

    if (isFunctionNode(node, ['insert', 'update', 'remove', 'save']))
        return isCollection(node.parent);  

    return false; 
}

var isBulk = function (node) {
    if (!node)
        return false;

    if (isFunctionNode(node, ['initializeOrderedBulkOp','initializeUnorderedBulkOp']))
        return isCollection(node.parent);  

    return false; 
}

var isBulkFind = function (node) {
    if (!node)
        return false;

    if (functionName = isFunctionNode(node)) {
        if (functionName == 'find') {
            return isBulk(node.parent);
        }
        else if (arrayContains(['arrayFilters', 'collation'], functionName)) {
            return isBulkFind(node.parent);
        }
    }

    return false;                   
}

var isReplication = function (node) {
    if (!node)
        return false;

    // rs.
    if (node.type == 'Identifier' && node.name == 'rs' && node.type2.length == 0)
        return true;       

    // this.rs.
    if (isProperty(node) == 'rs' && isGlobal(node.parent))
        return true;     

    return false; 
}  

var isSharding = function (node) {
    if (!node)
        return false;

    // sh.
    if (node.type == 'Identifier' && node.name == 'sh' && node.type2.length == 0)
        return true;       

    // this.sh.
    if (isProperty(node) == 'sh' && isGlobal(node.parent))
        return true;       

    return false; 
}   

var isPlanCache = function (node) {
    if (!node)
        return false;

    if (isFunctionNode(node, 'getPlanCache'))
        return isCollection(node.parent);  

    return false; 
}       

var isSession = function (node) {
    if (!node)
        return false;

    if (isFunctionNode(node, 'startSession'))
        return isMongo(node.parent);  

    return false; 
} 

// pls separate to check if have special case
// how about Map, JSON ?
var mongoObjects = ['NumberInt', 'NumberLong', 'NumberDecimal', 'ObjectId', 'Code', 'DBRef', 'DBPointer', 'Timestamp'];
mongoObjects.push('Int32', 'Long', 'Decimal128'); // mongosh
var isMongoObject = function (node) {
    if (!node)
        return false;

    if (isFunctionNode(node, mongoObjects) && !arrayContains(node.type2, 'property'))
        return true;

    return false;
}

var isObjectId = function (node) {
    if (!node)
        return false;

    // ObjectId.
    if (node.type == 'Identifier' && node.name == 'ObjectId' && node.type2.length == 0)
        return true;

    return false;
}

var possibleObjectIdCreate = ['fromDate'];
possibleObjectIdCreate.push('createFromBase64', 'createFromHexString'); // mongosh
var isObjectIdCreate = function (node) {
    if (!node)
        return false;

    if (isObjectId(node))
        return true;
    else if (functionName = isFunctionNode(node)) {
        if (arrayContains(possibleObjectIdCreate, functionName))
            return isObjectIdCreate(node.parent);
    }

    return false;
}

// have different function calls and properties
var isMongo = function (node) {
    if (!node)
        return false;

    if (isFunctionNode(node, 'Mongo') && !arrayContains(node.type2, 'property'))
        return true;

    if (isFunctionNode(node, 'getMongo'))
        return isDB(node.parent);     

    return false;     
}                

var binDataObjects = ['BinData', 'UUID', 'HexData', 'MD5'];
var isBinDataObject = function (node) {
    if (!node)
        return false;

    if (isFunctionNode(node, binDataObjects) && !arrayContains(node.type2, 'property'))
        return true;

    return false; 
}                

var isBinary = function (node) {
    if (!node)
        return false;

    // Binary.
    if (node.type == 'Identifier' && node.name == 'Binary' && node.type2.length == 0)
        return true;

    return false;
}

var possibleBinaryCreate = ['createFromBase64', 'createFromHexString'];
var isBinaryCreate = function (node) {
    if (!node)
        return false;

    if (isBinary(node))
        return true;
    else if (functionName = isFunctionNode(node)) {
        if (arrayContains(possibleBinaryCreate, functionName))
            return isBinaryCreate(node.parent);
    }

    return false;
}

var minMaxKey = ['MinKey', 'MaxKey'];
var isMinMaxKey = function (node) {
    if (!node)
        return false;

    if (node.type == 'Identifier' && arrayContains(minMaxKey, node.name) && !arrayContains(node.type2, 'property'))
        return true;

    if (name = isProperty(node))
        return arrayContains(minMaxKey, node.name) && isGlobal(node.parent);  
        
    return false;         
}                

// pls separate to check if have special case
var javascriptObjects = ['Array','Boolean','Date','Math','Number','RegExp','String','Function','Object']
var isJavascriptObject = function (node) {
    if (!node)
        return false;

    if (node.type == 'Identifier' && arrayContains(javascriptObjects, node.name) && node.type2.length == 0)
        return true;               

    if (name = isProperty(node))
        return arrayContains(javascriptObjects, node.name) && isGlobal(node.parent);   

    return false;         
}        

var isFunctionNode = function (node, possibleFunctionNames, allowSquareBracketsWithIdentifier = false) {
    if (!node)
        return false;

    /* 
        case: getCollection() // no computed
        {
            "type": "Identifier",
            "name": "getCollection"
        } 
        case: db.getCollection()
        {
            "type": "Identifier",
            "name": "getCollection",
            "computed": false
        }
        case: db['getCollection']() 
        {
            "type": "Literal",
            "value": "getCollection",
            "computed": true
        }       
        case: db[getCollection]()[test2] 
        {
            "type": "Identifier",
            "name": "getCollection",
            "computed": true
        }       
    */
    // remark: empty string is equal to false
    // to check empty string, pls use === or !==
    // undefined == null is true

    if (arrayLastElementEquals(node.type2, 'callee')) {
        if (node.type == 'Identifier' && (allowSquareBracketsWithIdentifier || node.computed == null || node.computed == false) && (possibleFunctionNames == null || arrayContains(possibleFunctionNames, node.name)))
            return node.name; 
        if ((node.type == 'Literal') && (possibleFunctionNames == null || arrayContains(possibleFunctionNames, node.value.toString())))
            return node.value.toString();   
    }

    return false; 
}    

var getFunctionArgs = function (node) {
    var functionArgs = null;

    if (isFunctionNode(node) !== false) {
        functionArgs = [];
        node.arguments.forEach(element => {
            if (element.type == 'Literal' && element.value)
                functionArgs.push(element.value.toString()); 
            else
                functionArgs.push('');
        });
    }

    return functionArgs; 
}  

var getFunctionArg = function (node, index) {
    if (isFunctionNode(node) !== false && node.arguments.length > index)
        return node.arguments[index];

    return null; 
}  

var isGlobal = function (node) {
    if (!node)
        return false;

    if (node.type == 'ThisExpression')
        return true;

    return false; 
} 

var isProperty = function (node, allowSquareBracketsWithIdentifier = false) {
    if (!node)
        return false;

    /* case: db['test']
        "property": {
            "type": "Literal",
            "value": "test",
            "raw": "'test'"
        },
        "computed": true
       case:db[test]
        "property": {
            "type": "Identifier",
            "name": "test"
        },
        "computed": true     
       case: db.test
        "property": {
            "type": "Identifier",
            "name": "test"
        },
        "computed": false   
    */
   // remark: empty string is equal to false
   // to check empty string, pls use === or !==

    if (arrayLastElementEquals(node.type2, 'property')) {
        if (node.type == 'Literal')
            return node.value.toString();
        if (node.type == 'Identifier' && (allowSquareBracketsWithIdentifier || node.computed == false))
            return node.name;            
    }

    return false; 
}  

var isIdentifier = function (node) {
    if (!node)
        return false;

    if (node.type == 'Identifier')
        return true;

    return false; 
}                 

var isStringValue = function (node) {
    if (!node)
        return false;

    if (node.type == 'Literal' && typeof node.value == 'string')
        return true;

    return false; 
}     

var isNumberValue = function (node) {
    if (!node)
        return false;

    if (node.type == 'Literal' && typeof node.value == 'number')
        return true;

    return false; 
}     

var nav_determineTypeForAutoCompletion = function (script, pos, printNode) {

    var parsedResult = {
        parentType: "",
        desiredTypes : [],
        functionCallArgs: null
    };

    try {
        printResult = {};        
        // if last char ., we should remove in order to obtain correct info
        // e.g. db.test.find(), if pos is 3 which is '.', acorn will return node that contain test too. as '.' belongs to property
        // pos -1 = index in string
        if (pos > 0 && script.length > pos && script[pos-1] === '.')
            pos--;
        parseScriptResult = nav_parseScript(script, pos, {findAssignments:true, findActualNode:true}, printNode, printResult);

        if (printNode) {
            parsedResult = Object.extend(parsedResult, printResult);
            parsedResult.parseNodeResult = parseScriptResult.actualNode;              
        } 

        var findAssignmentStatement = function (statement, assignments) {
            if (!assignments || assignments.length == 0)
                return null;
            if (statement.length == 0)
                return null;
        
            var isSameNode = function (source, target) {
                if (!source || !target)
                    return false;
        
                // check a == a or ['a'] == a or ['a'] == ['a']
                if (source.type == 'Identifier' && source.type == target.type)
                    return source.name === target.name;
                if (source.type == 'Literal' && source.type == target.type)
                    return source.value === target.value;
                if (source.type == 'Literal' && target.type == 'Identifier')
                    return source.value === target.name;
                if (source.type == 'Identifier' && target.type == 'Literal')
                    return source.name === target.value;      
            
                return false; 
            } 	
        
            // loop assignments to match statement
            var assignmentStatement = null;
            var currentIndex = assignments.length;                
            while (currentIndex > 0 && !assignmentStatement) {
                currentIndex--;
                assignment = assignments[currentIndex];
                // e.g. a.b == a.b
                if (assignment.length == statement.length) {
                    var found = false;
                    for (let i = 0; i < assignment.length; i++) {
                        found = isSameNode(assignment[i], statement[i]);
                        if (!found)
                            break;
                    }
        
                    // e.g. if found a.b, will obtain assignment in b. assignment data is stored in the last object
                    // remove matched assignment to prevent looping same one. e.g. a==a. will loop a and find a again if dont remove
                    if (found) {
                        assignmentStatement = assignment[assignment.length - 1].assignment;
                        assignments.splice(currentIndex, 1);
                    }
                }  
            }
            return assignmentStatement;
        }

        var replaceAllPossibleAssignments = function (srcStatement, assignments) {
            if (srcStatement && srcStatement.length > 0) {
                var newStatement = srcStatement.slice(0); 
                var assignmentStatement = null;
                var backupStatement = [];
                while (!assignmentStatement && newStatement.length > 0) {
                    // find assignment for current statement
                    assignmentStatement = findAssignmentStatement(newStatement, assignments);
                    if (assignmentStatement) {
                        // if find, update parent for search later
                        if (backupStatement.length > 0) {
                            tmpNode = backupStatement[backupStatement.length-1];
                            if (tmpNode.parent)
                            tmpNode.parent = assignmentStatement[assignmentStatement.length - 1];
                        } 
                        // combine previous nodes to find again
                        newStatement = [];
                        backupStatement.reverse();
                        newStatement.push(...assignmentStatement);
                        newStatement.push(...backupStatement);  
                        backupStatement = [];  

                        assignmentStatement = replaceAllPossibleAssignments(newStatement, assignments);
                        // parsedResult.assignment = assignmentStatement;
                    }
                    else
                    // if not find, will remove the last obj and find again
                        backupStatement.push(newStatement.pop());
                }

                // update parent and combine finally
                if (assignmentStatement) {
                    if (backupStatement.length > 0) {
                        tmpNode = backupStatement[backupStatement.length-1];
                        if (tmpNode.parent)
                        tmpNode.parent = assignmentStatement[assignmentStatement.length - 1];
                    } 
                    newStatement = [];
                    backupStatement.reverse();
                    newStatement.push(...assignmentStatement);
                    newStatement.push(...backupStatement);  
                    backupStatement = [];  
                }
                else
                    newStatement = srcStatement.slice(0); 
                return newStatement;
            }
            return [];
        }    

        if (parseScriptResult.actualNode && parseScriptResult.actualNode.length > 0) {
            var targetStatement = parseScriptResult.actualNode[parseScriptResult.actualNode.length - 1];
            if (printNode) {
                parsedResult.srcStatement = targetStatement.slice(0);
                parsedResult.assignments = parseScriptResult.assignments.slice(0);
            }
            targetStatement = replaceAllPossibleAssignments(targetStatement, parseScriptResult.assignments);
            if (printNode) {
                parsedResult.targetStatement = targetStatement.slice(0);
            }
            // obtain last obj from statement. can contain sub statement in statement, so have to loop to obtain the last one. e.g. in block
            var lastObj = null;
            if (targetStatement && targetStatement.length > 0) {
                lastObj = targetStatement;
                while (Array.isArray(lastObj))
                    lastObj = lastObj.slice(-1)[0];  
            }

            if (!lastObj) {
            }
            else if (isDB(lastObj)) {
                parsedResult.parentType = 'DB';
                parsedResult.desiredTypes = ['Collection', 'FunctionCall'];
                parsedResult.functionCallArgs = getFunctionArgs(lastObj);
            }
            else if (isCollection(lastObj)) {
                parsedResult.parentType = 'Collection';
                parsedResult.desiredTypes = ['Collection', 'FunctionCall'];
            }
            else if (isCursor(lastObj)) {
                parsedResult.parentType = 'Cursor';
                parsedResult.desiredTypes = ['FunctionCall', 'Property'];
            }
            else if (isCollectionFind(lastObj)) {
                parsedResult.parentType = 'CollectionFind';
                parsedResult.desiredTypes = ['FunctionCall'];
            }
            else if (isCollectionExplain(lastObj)) {
                parsedResult.parentType = 'CollectionExplain';
                parsedResult.desiredTypes = ['FunctionCall'];
            }
            else if (isCollectionExplainFind(lastObj)) {
                parsedResult.parentType = 'CollectionExplainFind';
                parsedResult.desiredTypes = ['FunctionCall'];
            }
            else if (isWriteResult(lastObj)) {
                parsedResult.parentType = 'WriteResult';
                parsedResult.desiredTypes = ['FunctionCall', 'Property'];
            }
            else if (isBulk(lastObj)) {
                parsedResult.parentType = 'Bulk';
                parsedResult.desiredTypes = ['FunctionCall'];
            }
            else if (isBulkFind(lastObj)) {
                parsedResult.parentType = 'BulkFind';
                parsedResult.desiredTypes = ['FunctionCall'];
            }
            else if (isReplication(lastObj)) {
                parsedResult.parentType = 'Replication';
                parsedResult.desiredTypes = ['FunctionCall'];
            }
            else if (isSharding(lastObj)) {
                parsedResult.parentType = 'Sharding';
                parsedResult.desiredTypes = ['FunctionCall'];
            }
            else if (isPlanCache(lastObj)) {
                parsedResult.parentType = 'PlanCache';
                parsedResult.desiredTypes = ['FunctionCall'];
            }
            else if (isSession(lastObj)) {
                parsedResult.parentType = 'Session';
                parsedResult.desiredTypes = ['FunctionCall'];
            }
            else if (isMongoObject(lastObj)){
                parsedResult.parentType = lastObj.name;  
                parsedResult.desiredTypes = ['FunctionCall', 'Property'];
            }
            else if (isObjectId(lastObj)){
                parsedResult.parentType = 'ObjectId';  
                parsedResult.desiredTypes = ['FunctionCall'];
            }
            else if (!isObjectId(lastObj) && isObjectIdCreate(lastObj)){
                parsedResult.parentType = 'ObjectId';  
                parsedResult.desiredTypes = ['FunctionCall', 'Property'];
            }
            else if (isMongo(lastObj)){
                parsedResult.parentType = 'Mongo';  
                parsedResult.desiredTypes = ['FunctionCall'];
            }
            else if (isMinMaxKey(lastObj)){
                parsedResult.parentType = lastObj.name;  
                parsedResult.desiredTypes = ['FunctionCall', 'Property'];
            }
            else if (isBinDataObject(lastObj) || (!isBinary(lastObj) && isBinaryCreate(lastObj))){
                parsedResult.parentType = 'BinData';  
                parsedResult.desiredTypes = ['FunctionCall'];
            }
            else if (isBinary(lastObj)) {
                parsedResult.parentType = 'Binary';
                parsedResult.desiredTypes = ['FunctionCall'];
            }
            else if (isJavascriptObject(lastObj)){
                parsedResult.parentType = lastObj.name;   
                parsedResult.desiredTypes = ['FunctionCall', 'Property'];
            }
            else if (isFunctionNode(lastObj) !== false){
                parsedResult.parentType = 'FunctionCall'; 
                parsedResult.desiredTypes = [];                    
            }
            else if (isStringValue(lastObj)){
                parsedResult.parentType = 'StringValue'; 
                parsedResult.desiredTypes = [];                    
            }
            else if (isNumberValue(lastObj)){
                parsedResult.parentType = 'NumberValue'; 
                parsedResult.desiredTypes = [];                    
            }
            else if (isProperty(lastObj) !== false){
                parsedResult.parentType = 'Property'; 
                parsedResult.desiredTypes = [];                    
            }
            else if (isIdentifier(lastObj)){
                parsedResult.parentType = 'Identifier'; 
                parsedResult.desiredTypes = [];                    
            }
            else{
                parsedResult.parentType = '';   
                parsedResult.desiredTypes = [];       
            }
        }
    } catch(e) {
        throw(e);
    } 
    return parsedResult; 
}

var nav_determineCollectionMethod = function (script, printNode) {
    var parsedResult = {
        databaseName: "",
        collectionName : null,
        functions: []
    };

    try {
        var foundCollection = false;
        printResult = {};
        parseScriptResult = nav_parseScript(script, -1, {}, printNode, printResult);

        if (printNode) {
            parsedResult = Object.extend(parsedResult, printResult);
            parsedResult.parseNodeResult = parseScriptResult.fullNode;              
        } 

        // we dont handle multi statements 
        if (parseScriptResult.fullNode && parseScriptResult.fullNode.length == 1) {
            var foundCollectionFunction = false;
            var skipCollectionName = false;
            var firstStatement = parseScriptResult.fullNode[0];
            // Array.prototype.some
            // break when the callback returns true
            firstStatement.some(element => {
                if (isDB(element)) {
                    // will skip not Literal value for db and collection
                    // if next element is db too, will rewrite previous one
                    var args = getFunctionArgs(element);
                    if (args && args.length > 0)
                        parsedResult.databaseName = args[0];
                }
                else if (isCollection(element, true) && !foundCollectionFunction) {
                    // if next element is collection too, will combine with previous one
                    // once found Identifier, collection name will become empty except dot property case
                    // if found function already, will not treat such element as collection
                    if (!skipCollectionName) {
                        foundCollection = true;
                        var collectionName = '';
                        // for getCollection
                        if (isFunctionNode(element) !== false) { 
                            var args = getFunctionArgs(element);
                            if (args && args.length > 0) {
                                var arg = getFunctionArg(element, 0);
                                if (arg && arg.type == 'Identifier')
                                    skipCollectionName = true;
                                else
                                    collectionName = args[0];  
                            }
                            else
                                skipCollectionName = true;               
                        }
                        else if (isProperty(element, true) !== false) {
                            // db[collection]
                            if (element.type == 'Identifier' && element.computed)   
                                skipCollectionName = true;
                            // db['collection']
                            else if (element.value)     
                                collectionName = element.value.toString();
                            // db.collection
                            else if (element.name)      
                                collectionName = element.name;
                        }
                        if (!skipCollectionName) {
                            if (parsedResult.collectionName == null)
                                parsedResult.collectionName = collectionName;
                            else
                                parsedResult.collectionName = parsedResult.collectionName + '.' + collectionName;
                        }
                        else
                            parsedResult.collectionName = '';
                    }
                }
                // remark, dont support function name is an Identifier in []
                else if (functionName = isFunctionNode(element)) {
                    foundCollectionFunction = true;
                    var funcInfo = {
                        name:"",
                        arguments:[]
                    }
                    funcInfo.name = functionName;
                    element.arguments.forEach(argument => {
                        // use functionEnd to get whole function part
                        if (argument.functionEnd)
                            funcInfo.arguments.push(script.substring(argument.start, argument.functionEnd));
                        else
                            funcInfo.arguments.push(script.substring(argument.start, argument.end));
                    });  
                    parsedResult.functions.push(funcInfo);
                } 
                else {
                    // if have unexpected elements, e.g. property, etc
                    foundCollection = false;
                    return true;
                }
                // false to continue
                return false;
            });                         

        }
    } catch(e) {
        throw(e);
    } 

    // if not found, dont return parsedResult
    if (foundCollection)
        return parsedResult; 
}

var nav_parseScriptForVariableList = function (script) {
    try {
        fullNode = acorn.parse_dammit(script, {});
        var variables = new Set; 
        acorn.walk.simple(fullNode, {
            // var a, let a, const a
            VariableDeclaration(node) {
                if (node.declarations) {
                    node.declarations.forEach(element => {
                        if (element.id)
                            variables.add(element.id.name);
                    });    
                }
            },
            // a = xxx
            AssignmentExpression(node) {
                if (node.operator && node.operator == '=') {
                    if (node.left && node.left.name) {
                        variables.add(node.left.name);
                    }
                }
            }
          }); 
          
        return variables;
    } catch (error) {
        throw e;
    }

    return [];
}